/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.registry;

import com.github.talrey.createdeco.Registration;
import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.github.talrey.createdeco.connected.SheetMetalCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalSlabCTBehaviour;
import com.github.talrey.createdeco.connected.SheetMetalVertCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.registry.DecoCreativeModeTab;
import com.jozufozu.flywheel.util.NonNullSupplier;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.Registrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class SheetMetal {
    public static HashMap<String, BlockEntry<Block>> SHEET_METAL_BLOCKS = new HashMap();
    public static HashMap<String, BlockEntry<StairBlock>> SHEET_STAIRS = new HashMap();
    public static HashMap<String, BlockEntry<SlabBlock>> SHEET_SLABS = new HashMap();
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> SHEET_VERT_SLABS = new HashMap();
    static HashMap<String, NonNullSupplier<Item>> METAL_LOOKUP = new HashMap();

    private static void initialize() {
        METAL_LOOKUP.put("Andesite", (NonNullSupplier<Item>)((NonNullSupplier)() -> ((CasingBlock)AllBlocks.ANDESITE_CASING.get()).m_5456_()));
        METAL_LOOKUP.put("Zinc", (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)AllBlocks.ZINC_BLOCK.get()).m_5456_()));
        METAL_LOOKUP.put("Copper", (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.f_151000_));
        METAL_LOOKUP.put("Brass", (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)AllBlocks.BRASS_BLOCK.get()).m_5456_()));
        METAL_LOOKUP.put("Iron", (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.f_41913_));
        METAL_LOOKUP.put("Gold", (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.f_41912_));
        METAL_LOOKUP.put("Netherite", (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.f_42791_));
        METAL_LOOKUP.put("Cast Iron", (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)Registration.CAST_IRON_BLOCK.get()).m_5456_()));
    }

    public static BlockBuilder<Block, ?> buildSheetMetalBlock(Registrate reg, NonNullSupplier<Item> material, String name, ResourceLocation texture) {
        return (BlockBuilder)((BlockBuilder)reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_metal", Block::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, name.contains("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), texture))).tag(new TagKey[]{BlockTags.f_144282_}).lang(name + " Sheet Metal").defaultLoot().item().properties(p -> name.contains("Netherite") ? p.m_41486_() : p).build()).recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx, 4)).onRegister(CreateRegistrate.connectedTextures(new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(name)).getSupplier()));
    }

    public static BlockBuilder<StairBlock, ?> buildSheetMetalStair(Registrate reg, NonNullSupplier<Item> material, String name, ResourceLocation texture) {
        return (BlockBuilder)((BlockBuilder)reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_stairs", props -> new StairBlock(() -> ((Block)Blocks.f_50193_).m_49966_(), props)).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, name.contains("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> name.contains("Netherite") ? p.m_41486_() : p).build()).tag(new TagKey[]{BlockTags.f_13030_}).tag(new TagKey[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), texture)).lang(name + " Sheet Stairs").recipe((ctx, prov) -> {
            prov.stonecutting(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx);
            prov.stairs(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx, null, false);
        }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(name)).getSupplier()));
    }

    public static BlockBuilder<SlabBlock, ?> buildSheetMetalSlab(Registrate reg, NonNullSupplier<Item> material, String name, ResourceLocation texture) {
        return (BlockBuilder)((BlockBuilder)reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_slab", SlabBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, name.contains("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> name.contains("Netherite") ? p.m_41486_() : p).build()).tag(new TagKey[]{BlockTags.f_13031_}).tag(new TagKey[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/" + name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_metal"), texture)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).lang(name + " Sheet Slab").recipe((ctx, prov) -> {
            prov.stonecutting(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx, 2);
            prov.slab(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx, null, false);
        }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalSlabCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(name)).getSupplier()));
    }

    public static BlockBuilder<VerticalSlabBlock, ?> buildSheetMetalVert(Registrate reg, NonNullSupplier<Item> material, String name, ResourceLocation texture) {
        return (BlockBuilder)((BlockBuilder)reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_slab_vert", VerticalSlabBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, name.contains("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56725_)).item().properties(p -> name.contains("Netherite") ? p.m_41486_() : p).build()).tag(new TagKey[]{BlockTags.f_144282_}).blockstate((ctx, prov) -> {
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", texture);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", texture);
            int y = 0;
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE)))));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).recipe((ctx, prov) -> {
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)SHEET_SLABS.get(name).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)material.get()})).m_176498_((Consumer)prov);
            prov.stonecutting(DataIngredient.items((ItemLike)((Item)material.get()), (ItemLike[])new Item[0]), (Supplier)ctx, 2);
        }).onRegister(CreateRegistrate.connectedTextures(new SheetMetalVertCTBehaviour(SpriteShifts.SHEET_METAL_SIDES.get(name)).getSupplier()));
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.METALS_GROUP);
        SheetMetal.initialize();
        Registration.METAL_TYPES.forEach((metal, getter) -> {
            ResourceLocation texture = new ResourceLocation("createdeco", "block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_metal");
            SHEET_METAL_BLOCKS.put((String)metal, (BlockEntry<Block>)SheetMetal.buildSheetMetalBlock(reg, METAL_LOOKUP.get(metal), metal, texture).register());
            SHEET_STAIRS.put((String)metal, (BlockEntry<StairBlock>)SheetMetal.buildSheetMetalStair(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)SHEET_METAL_BLOCKS.get(metal).get()).m_5456_()), metal, texture).register());
            SHEET_SLABS.put((String)metal, (BlockEntry<SlabBlock>)SheetMetal.buildSheetMetalSlab(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)SHEET_METAL_BLOCKS.get(metal).get()).m_5456_()), metal, texture).register());
            SHEET_VERT_SLABS.put((String)metal, (BlockEntry<VerticalSlabBlock>)SheetMetal.buildSheetMetalVert(reg, (NonNullSupplier<Item>)((NonNullSupplier)() -> ((Block)SHEET_METAL_BLOCKS.get(metal).get()).m_5456_()), metal, texture).register());
        });
    }
}

